<?php

namespace Drupal\fast_error_pages\EventSubscriber;

use Drupal\Core\Cache\Cache;
use Drupal\Core\Cache\CacheableResponseInterface;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\fast_error_pages\FastErrorPageManager;
use Drupal\fast_error_pages\Plugin\FastError\FastErrorPagePluginBase;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

class FastErrorPageStoreCacheInfo implements EventSubscriberInterface {

  public function __construct(
    protected CacheBackendInterface $cacheBackend,
    protected FastErrorPageManager $errorManager,
    protected AccountProxyInterface $currentUser,
    protected ModuleHandlerInterface $moduleHandler,
  ) {}

  public static function getSubscribedEvents(): array {
    return [KernelEvents::RESPONSE => 'onResponse'];
  }

  public function onResponse(ResponseEvent $event): void {
    $response = $event->getResponse();

    if (!$this->currentUser->isAnonymous()) {
      return;
    }

    $cid_parts = [];
    $this->moduleHandler->alter('fast_error_pages_cache_contexts', $cid_parts);

    foreach ($this->errorManager->getDefinitions() as $code => $callback) {
      $cid = implode(':', array_merge([$code], $cid_parts));
      $cached_info = $this->cacheBackend->get($cid);

      if ($cached_info) {
        continue;
      }

      /** @var FastErrorPagePluginBase $plugin_instance */
      $plugin_instance = $this->errorManager->createInstance($code);

      if ($plugin_instance->applies($event->getRequest()) && $response instanceof CacheableResponseInterface) {
        $cacheable_metadata = $response->getCacheableMetadata();
        $tags = $cacheable_metadata->getCacheTags();
        $contexts = $cacheable_metadata->getCacheContexts();

        $this->cacheBackend->set($cid, [
          'tags' => $tags,
          'contexts' => $contexts,
        ], Cache::PERMANENT, $tags);
      }
    }
  }

}
