<?php

namespace Drupal\fast_error_pages\FastErrorPage;

use Drupal\Core\Url;
use Drupal\fast_error_pages\Plugin\FastErrorPage;
use Drupal\fast_error_pages\Plugin\FastError\FastErrorPagePluginBase;

#[FastErrorPage(404)]
class FastErrorPage404 extends FastErrorPagePluginBase {

  public function getUrl(): ?string {
    $config = $this->configFactory->get('system.site');
    $page_404 = $config->get('page')['404'] ?? '';

    if (empty($page_404)) {
      return NULL;
    }

    return Url::fromUserInput($page_404)->setAbsolute()->toString();
  }

}
