# Fast error pages
The Fast Error Pages module improves performance by serving cached error pages such as 404 Not Found and 403 Access Denied before Drupal fully bootstraps.

In a normal Drupal setup, each 404 or 403 request triggers a full bootstrap to determine the route and render the error page, which can be expensive on high-traffic sites or those hit by many invalid URLs.

Drupal core’s Fast 404 can return static HTML for predefined paths but cannot render dynamic or themed error pages.
Fast Error Pages solves this by caching and serving your actual themed error pages while still respecting Drupal’s cache tags and invalidation system.

## Requirements

This module requires a full page caching solution that supports cache tags, such as Drupal's built-in Internal Page Cache or a reverse proxy like Varnish. 
It has to invalidate cached error pages when using a HTTP Post request.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

There are no configuration provided. It uses the 404 and 403 pages as configured in the basic site settings.

## Maintainers

- Jolan Bekaert - [j_bekaert](https://www.drupal.org/u/j_bekaert)
- Brecht Ceyssens - [bceyssens](https://www.drupal.org/u/bceyssens)

**Supporting organization:**

- [Nascom](https://www.drupal.org/nascom)
- [MakeItFly](https://www.drupal.org/make-it-fly)
- [Reynaers Group](https://www.drupal.org/reynaers-group)