<?php

/**
 * Allows modules to alter the cache context parts used for fast exception responses.
 *
 * This hook lets other modules add or modify cache context identifiers that
 * are used to build the cache ID for fetched exception pages (such as 404s or
 * 403s). For example, a multilingual site could add the current language code,
 * or a multisite setup could add a domain or site identifier.
 *
 * @param array $cid_parts
 *   An indexed array of cache ID parts. The first element is always the base
 *   `$prefix` provided by the exception subscriber. Other modules can append
 *   additional context parts as needed.
 *
 */
function hook_fast_error_pages_cache_contexts_alter(array &$cid_parts): void {
  // Example: Add the current language code if multilingual.
  if (\Drupal::languageManager()->isMultilingual()) {
    $cid_parts[] = \Drupal::languageManager()->getCurrentLanguage()->getId();
  }

  // Example: Add domain ID if the Domain module is available.
  if (\Drupal::moduleHandler()->moduleExists('domain')) {
    $domain = \Drupal::service('domain.negotiator')->getActiveDomain();
    if ($domain) {
      $cid_parts[] = $domain->id();
    }
  }
}
