<?php

namespace Drupal\fast_error_pages\FastErrorPage;

use Drupal\Core\Url;
use Drupal\fast_error_pages\Plugin\FastErrorPage;
use Drupal\fast_error_pages\Plugin\FastError\FastErrorPagePluginBase;

#[FastErrorPage(403)]
class FastErrorPage403 extends FastErrorPagePluginBase {

  public function getUrl(): ?string {
    $config = $this->configFactory->get('system.site');
    $page_403 = $config->get('page')['403'] ?? '';

    if (empty($page_403)) {
      return NULL;
    }

    return Url::fromUserInput($page_403)->setAbsolute()->toString();
  }

}
