<?php

namespace Drupal\fast_revision_purge\Service;

use Drupal\Core\Database\Connection;
use Psr\Log\LoggerInterface;

/**
 * Lightweight wrapper for DB-platform specific switches.
 *
 * Currently only exposes the active driver. Kept as a seam for future
 * platform-specific behaviors (e.g., MySQL vs. PostgreSQL nuances).
 */
final class DbPlatform {

  /**
   * Constructs the DbPlatform service.
   *
   * @param \Drupal\Core\Database\Connection $db
   *   Active database connection.
   * @param \Psr\Log\LoggerInterface $logger
   *   Logger for platform-related diagnostics (reserved for future use).
   */
  public function __construct(
    private Connection $db,
    private LoggerInterface $logger,
  ) {}

  /**
   * Returns the current DB driver identifier.
   *
   * @return string
   *   Machine name of the active database driver (e.g., 'mysql', 'pgsql').
   */
  public function driver(): string {
    return (string) $this->db->driver();
  }

}
