<?php

declare(strict_types=1);

namespace Drupal\featureflags_extensions\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\featureflags_extensions\FeatureflagsExtensionsRoutesInterface;

/**
 * Defines the featureflags routes entity type.
 *
 * @ConfigEntityType(
 *   id = "featureflags_routes",
 *   label = @Translation("Featureflags Routes"),
 *   label_collection = @Translation("Featureflags Routess"),
 *   label_singular = @Translation("featureflags routes"),
 *   label_plural = @Translation("featureflags routess"),
 *   label_count = @PluralTranslation(
 *     singular = "@count featureflags routes",
 *     plural = "@count featureflags routess",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\featureflags_extensions\FeatureflagsExtensionsRoutesListBuilder",
 *     "form" = {
 *       "add" = "Drupal\featureflags_extensions\Form\FeatureflagsExtensionsRoutesForm",
 *       "edit" = "Drupal\featureflags_extensions\Form\FeatureflagsExtensionsRoutesForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *   },
 *   config_prefix = "featureflags_extensions_routes",
 *   admin_permission = "administer featureflags_extensions_routes",
 *   links = {
 *     "collection" = "/admin/structure/featureflags-extensions-routes",
 *     "add-form" = "/admin/structure/featureflags-extensions-routes/add",
 *     "edit-form" = "/admin/structure/featureflags-extensions-routes/{featureflags_routes}",
 *     "delete-form" = "/admin/structure/featureflags-extensions-routes/{featureflags_routes}/delete",
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "routes",
 *   },
 * )
 */
final class FeatureflagsExtensionsRoutes extends ConfigEntityBase implements FeatureflagsExtensionsRoutesInterface {

  /**
   * The example ID.
   */
  protected string $id;

  /**
   * The routes.
   */
  protected ?string $routes;

  /**
   * Returns the routes.
   *
   * @return string|null
   *   The routes.
   */
  public function getRoutes(): ?string {
    return $this->routes;
  }

  /**
   * Sets the routes.
   *
   * @param string $routes
   *   The routes.
   */
  public function setRoutes(string $routes): void {
    $this->routes = $routes;
  }

}
