<?php

namespace Drupal\featureflags_extensions\Routing;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\featureflags_extensions\FeatureFlagsExtensionsServiceInterface;
use Symfony\Component\Routing\RouteCollection;

/**
 * Route subscriber for blocking disabled routes.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * The featureflags extensions service.
   *
   * @var \Drupal\featureflags_extensions\FeatureFlagsExtensionsServiceInterface
   */
  protected FeatureFlagsExtensionsServiceInterface $featureflagExtensions;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected EntityTypeManagerInterface $entityTypeManager;

  public function __construct(EntityTypeManagerInterface $entity_type_manager, FeatureFlagsExtensionsServiceInterface $featureflags_extensions) {
    $this->entityTypeManager = $entity_type_manager;
    $this->featureflagExtensions = $featureflags_extensions;
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    /**
* @var \Drupal\featureflags\Entity\FeatureFlagInterface[] $flags
*/
    $flags = $this->entityTypeManager->getStorage('featureflag')
      ->loadByProperties([]);

    foreach ($flags as $flag) {
      if (!$flag->getState()) {
        $config = $this->featureflagExtensions->getExtension($flag, 'featureflags_routes');
        if (!empty($config)) {
          $routes_blob = $config->getRoutes();
          if (!empty($routes_blob)) {
            $routes = array_map('trim', explode("\n", $routes_blob));
            foreach ($routes as $route) {
              if ($route_objct = $collection->get($route)) {
                $route_objct->setRequirement('_access', 'FALSE');
              }
            }
          }
        }
      }
    }
  }

}
