<?php

declare(strict_types=1);

namespace Drupal\featureflags_extensions\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\featureflags_extensions\FeatureflagsExtensionsPermissionsInterface;

/**
 * Defines the featureflags ?permissions entity type.
 *
 * @ConfigEntityType(
 *   id = "featureflags_permissions",
 *   label = @Translation("Featureflags Permissions"),
 *   label_collection = @Translation("Featureflags Permissionss"),
 *   label_singular = @Translation("featureflags permissions"),
 *   label_plural = @Translation("featureflags permissionss"),
 *   label_count = @PluralTranslation(
 *     singular = "@count featureflags permissions",
 *     plural = "@count featureflags permissionss",
 *   ),
 *   handlers = {
 *     "list_builder" =
 *   "Drupal\featureflags_extensions\FeatureflagsExtensionsPermissionsListBuilder",
 *     "form" = {
 *       "add" =
 *   "Drupal\featureflags_extensions\Form\FeatureflagsExtensionsPermissionsForm",
 *       "edit" =
 *   "Drupal\featureflags_extensions\Form\FeatureflagsExtensionsPermissionsForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *   },
 *   config_prefix = "featureflags_extensions_permissions",
 *   admin_permission = "administer featureflags_extensions_permissions",
 *   links = {
 *     "collection" = "/admin/structure/featureflags-extensions-permissions",
 *     "add-form" = "/admin/structure/featureflags-extensions-permissions/add",
 *     "edit-form" =
 *   "/admin/structure/featureflags-extensions-permissions/{featureflags_permissions}",
 *     "delete-form" =
 *   "/admin/structure/featureflags-extensions-permissions/{featureflags_permissions}/delete",
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "permissions",
 *   },
 * )
 */
final class FeatureflagsExtensionsPermissions extends ConfigEntityBase implements FeatureflagsExtensionsPermissionsInterface {

  /**
   * The example ID.
   */
  protected string $id;

  /**
   * The permissions.
   *
   * @var array|null
   */
  protected ?array $permissions;

  /**
   * Returns the permissions.
   */
  public function getPermissions() {
    return $this->permissions;
  }

  /**
   * Sets the permissions.
   */
  public function setPermissions($permissions) {
    $this->permissions = $permissions;
  }

}
