<?php

namespace Drupal\featureflags_extensions;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\featureflags\Entity\FeatureFlagInterface;

/**
 * Service for featureflags extensions.
 */
class FeatureFlagsExtensionsService implements FeatureFlagsExtensionsServiceInterface {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  private EntityTypeManagerInterface $entityTypeManager;

  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public function getExtension(FeatureFlagInterface $flag, string $extension, bool $create = FALSE): ?ConfigEntityInterface {
    $config = $this->entityTypeManager->getStorage($extension)
      ->load($flag->id());
    if (empty($config) && $create) {
      $config = $this->entityTypeManager->getStorage($extension)
        ->create(['id' => $flag->id()]);
      $config->save();
    }
    return $config;
  }

}
