<?php

namespace Drupal\featureflags_extensions\Form;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Form\FormBase;
use Drupal\featureflags_extensions\FeatureFlagsExtensionsService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for featureflags extensions forms.
 */
abstract class FeatureFlagsExtensionsForm extends FormBase {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected EntityTypeManagerInterface $entityTypeManager;

  /**
   * The featureflags extensions manager.
   *
   * @var \Drupal\featureflags_extensions\FeatureFlagsExtensionsService
   */
  private FeatureFlagsExtensionsService $featureflagsExtensions;

  /**
   * Returns the corresponding config entity.
   */
  public function getConfigEntity(): ?ConfigEntityInterface {
    $flag = $this->getRouteMatch()->getParameter('featureflag');
    if (!empty($flag)) {
      return $this->featureflagsExtensions->getExtension($flag, $this->getConfigEntityType(), TRUE);
    }
    return NULL;
  }

  public function __construct(EntityTypeManagerInterface $entity_type_manager, FeatureFlagsExtensionsService $featureflags_extensions) {
    $this->entityTypeManager = $entity_type_manager;
    $this->featureflagsExtensions = $featureflags_extensions;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
          $container->get('entity_type.manager'),
          $container->get('featureflags_extensions.service')
      );
  }

  /**
   * Returns the corresponding config entity type.
   */
  abstract public function getConfigEntityType();

}
