<?php

namespace Drupal\featureflags_extensions\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Form class for the featureflags route form.
 */
class RoutesForm extends FeatureFlagsExtensionsForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->getConfigEntity();

    $form['routes'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Description'),
      '#default_value' => $config->getRoutes(),
      '#description' => $this->t("Description for the feature flag."),
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->getConfigEntity();
    $config->setRoutes($form_state->getValue('routes'));
    $config->save();

    $flag = $this->getRouteMatch()->getParameter('featureflag');

    $this->messenger()->addStatus(
          $this->t(
              'Saved the %label feature flag.', [
                '%label' => $flag->label(),
              ]
          )
      );
    $form_state->setRedirectUrl($flag->toUrl('collection'));
  }

  /**
   * {@inheritdoc}
   */
  public function getConfigEntityType() {
    return 'featureflags_routes';
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'featureflags_routes';
  }

}
