<?php

namespace Drupal\featureflags_extensions\TwigExtension;

use Drupal\featureflags\Entity\FeatureFlag;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Twig extension for the featureflags module.
 */
class FeatureFlagsTwigExtension extends AbstractExtension {

  /**
   * {@inheritdoc}
   */
  public function getFunctions() {
    return [
      new TwigFunction(
          'featureflag_active',
          [$this, 'isFeatureFlagActive'],
          ['is_safe' => ['html']]
      ),
    ];
  }

  /**
   * Checks if the given flag id is active.
   */
  public function isFeatureFlagActive($flag_id) {
    return FeatureFlag::isActive($flag_id);
  }

}
