# Feeds Enhanced

Provides enhancements for the Drupal Feeds module with additional fetcher, parser, processor, and target plugins.

## Overview

Feeds Enhanced extends Drupal's Feeds module with the following capabilities:

* **SFTP Fetcher**: Securely download feed data from SFTP servers using key-based authentication
* **HTTP Unconditional Fetcher**: Download feed data from HTTP sources without conditional GET restrictions
* **Null Data Source**: A special fetcher for programmatically providing feed data
* **INI Parser**: Parse INI-formatted files into structured data for import
* **Entity Data Parser**: Parse entity data directly for import
* **Enhanced Content Entity Processor**: An extended version of the standard Feeds content entity processor with additional features
* **Multiple Target Plugins**: Enhanced versions of standard field targets with improved functionality
* **Token Support (submodule)**: Universal token expansion for all Feeds text fields and configurations - use tokens anywhere in your Feed configurations

This module has been used in production environments and is now available as a beta release for community testing.

## Requirements

* Drupal 10.1+ or Drupal 11
* Feeds module
* Key module (for SFTP authentication)

## Installation

1. Install the module via Composer:
   ```
   composer require drupal/feeds_enhanced:^1.0@beta
   ```

2. Enable the module through Drupal's admin interface or via Drush:
   ```
   drush en feeds_enhanced
   ```

## Usage

### SFTP Fetcher

The SFTP Fetcher allows you to securely download feed files from SFTP servers using key-based authentication.

#### Configuration

1. First, create a key in the Key module that contains your SSH private key
2. Create a new Feed Type and select "Download via SFTP" as the fetcher
3. Configure the connection settings:
   - Host: The SFTP server hostname
   - Port: The SFTP server port (usually 22)
   - Username: SFTP account username
   - Authentication Key: Select the key entity containing your SSH private key
   - Remote File Path: Path to the file on the SFTP server

The fetcher will securely connect to the SFTP server and download the specified file during feed import.

### HTTP Unconditional Fetcher

Similar to the standard HTTP fetcher but always downloads the complete feed, ignoring conditional GET mechanisms.

#### Configuration

1. Create a new Feed Type and select "Download Unconditionally" as the fetcher
2. Enter the URL of the feed source

This is particularly useful when:
- You need to maintain historical records of all feed data
- The feed source updates content in-place without changing modification dates
- You need to bypass caching mechanisms

### Null Data Source / Entity Data Parser Combo

This powerful combination allows you to use existing entity data as the source for a feed import, enabling bulk transformations and creation of related entities.

#### Configuration

1. Create a new Feed Type and select "Null Data Source" as the fetcher
2. Select "Entity Data Parser" as the parser
3. Configure your mappings to use fields from the source entity

#### Example Use Cases

- Generate companion entities based on existing content
- Transform data from one entity type to another
- Create derivative content based on complex rules
- Bulk update related entities when primary content changes

### INI Parser

Parses INI-formatted files with support for sections.

#### Configuration

1. Create a new Feed Type with any fetcher that can retrieve INI files
2. Select "INI Parser" as the parser
3. Map INI sections and properties to your target entity fields

### Enhanced Content Entity Processor

The enhanced processor improves upon the standard Feeds processor with:
- Support for collecting multiple source values into single multi-value fields
- Better error handling
- Additional configuration options

#### Configuration

When creating a Feed Type, the Enhanced Content Entity Processor is automatically used instead of the standard processor.

### Token Support (Submodule)

The **Feeds Enhanced - Token Support** submodule provides universal token expansion for all Feeds text fields and configurations. Once enabled, tokens are automatically expanded during every feed import.

#### Features

- **Universal expansion**: Works on all Feed and Feed Type text fields
- **Automatic integration**: No configuration needed
- **Performance optimized**: Session-based caching prevents redundant expansion
- **All token types supported**: feed, feed-type, current-user, date, site, and custom tokens

#### Enable the Submodule

```bash
drush en feeds_enhanced_tokens -y
```

#### Example Uses

**Dynamic SFTP paths:**
```
Directory: /exports/[date:custom:Y/m/d]
Filename: import-[date:custom:His].csv
```

**Pantheon SI integration:**
```
Feed source: 127.0.0.1:[pantheon_si_tunnel:pantheon_soip_ldap]/data.ldif
```

**User-specific sources:**
```
Feed source: https://api.example.com/user-[current-user:uid]/feed.json
```

See the submodule's README for comprehensive documentation and more examples.

## Demo Feed Type Configuration

To help you get started, here is a sample Feed Type configuration for SFTP import. You can import this YAML via the Feeds UI or Drush:

```yaml
id: demo_sftp_feed
label: 'Demo SFTP Feed'
fetcher: sftp
fetcher_configuration:
  host: 'sftp.example.com'
  port: 22
  username: 'demo'
  password: 'demo_key_id' # Key module entity ID
  directory: '/feeds'
  filename_pattern: 'demo.csv'
  timeout: 90
parser: csv
parser_configuration:
  delimiter: ','
  no_headers: false
  header_lines: 1
processor: entity:node
processor_configuration:
  values:
    type: article
mappings:
  - target: title
    map: { value: title }
  - target: body
    map: { value: body }
    settings: { format: plain_text }
```

**Instructions:**
- Copy the above YAML into a file.
- Import it using the Feeds UI or with Drush (`drush config-import`).
- Update the SFTP and Key settings to match your environment.

## Beta Status Note

This is a Beta release intended for community testing. While the module has been used in production environments, you may encounter issues in different configurations. Please report any bugs or feature requests to the issue queue.

## License

This project is licensed under the GPL v2 or later.
