# Changelog

All notable changes to Feeds Enhanced - Token Support will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0-beta3] - 2025-01-06

### Added
- Initial beta release
- Universal token expansion for all Feeds text fields and configurations
- Event-based token processing via INIT_IMPORT event (priority 1000)
- Session-based token caching for performance optimization
- Support for any Drupal token (feed, feed-type, current-user, date, site, custom tokens)
- Automatic cache cleanup after import completion
- Comprehensive README with usage examples
- Support for Drupal 10.1+ and Drupal 11

### Dependencies
- Requires Feeds module (^3.0@beta)
- Requires Token module (^1.0)
- Does NOT require feeds_enhanced (packaged as submodule for convenience only)

### Features
- Dynamic SFTP paths using date tokens
- Pantheon Secure Integration tunnel token support
- User-specific feed sources
- Dynamic feed labels
- Processor default values with token support
- Programmatic token injection

### Technical Implementation
- TokenExpander service for centralized token processing
- EventSubscriber for automatic integration with Feeds pipeline
- Recursive configuration traversal for nested token expansion
- Early exit optimization for performance
- Session-based caching prevents redundant expansion

### Notes
- First public release as submodule of Feeds Enhanced
- Addresses community issues #3131079 and #3282260
- Module is production-ready but marked as beta to gather community feedback
- APIs are stable and backward compatibility will be maintained
