# Changelog

All notable changes to Feeds Enhanced will be documented in this file.

## [1.0.0-beta4] - 2025-01-06

### Changed
- **SFTP Fetcher**: Refactored to use `hostname:port` format in Host field instead of separate Port field
  - Port defaults to 22 if omitted
  - Internally stores host and port separately for backward compatibility

### Fixed
- Added missing `options` module dependency to Kernel tests
- Updated MockSftpClient in functional tests to implement `defaultPort()` method

## [1.0.0-beta3] - 2025-01-06

### Added
- New submodule: **Feeds Enhanced - Token Support**
  - Universal token expansion for all Feeds text fields and configurations
  - Automatic integration via event subscriber (INIT_IMPORT @ priority 1000)
  - Session-based caching for performance optimization
  - Support for any Drupal token (feed, feed-type, current-user, date, site, custom tokens)
  - Token browser on Feed and Feed Type forms for easy token discovery
  - Requires Token module for full functionality
  - Addresses community issues [#3131079](https://www.drupal.org/project/feeds/issues/3131079) and [#3282260](https://www.drupal.org/project/feeds/issues/3282260)

### Changed
- feeds_enhanced_tokens now requires Token module (hard dependency)
- feeds_enhanced_tokens no longer depends on feeds_enhanced (only feeds + token)

### Documentation
- Comprehensive README for feeds_enhanced_tokens with usage examples
- Examples include dynamic SFTP paths, Pantheon SI tunnel integration, user-specific sources

## [1.0.0-beta1] - 2025-07-14

### Added
- Initial beta release
- SFTP Fetcher for secure file transfers using key-based authentication
- HTTP Unconditional Fetcher for downloading feeds without conditional GET restrictions
- Null Data Source for programmatic feed data
- INI Parser for processing INI-formatted feed files
- Entity Data Parser for direct entity data parsing
- Enhanced Content Entity Processor with improved functionality
- Multiple enhanced target plugins for various field types

### Notes
- This is the first public beta release after successful private production use
- APIs may still undergo minor changes based on community feedback
