<?php

declare(strict_types=1);

namespace Drupal\Tests\feeds_enhanced_tokens\Functional;

use Drupal\Tests\feeds\Functional\FeedsBrowserTestBase;

/**
 * Tests token browser display on feed forms.
 *
 * @group feeds_enhanced_tokens
 */
class TokenBrowserTest extends FeedsBrowserTestBase
{

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'feeds',
    'feeds_enhanced_tokens',
    'token',
    'node',
    'user',
    'file',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Tests token browser appears on feed entity form.
   */
  public function testTokenBrowserOnFeedForm(): void
  {
    $feed_type = $this->createFeedType([
      'fetcher' => 'http',
      'parser' => 'csv',
      'processor' => 'entity:node',
      'processor_configuration' => [
        'values' => ['type' => 'article'],
      ],
    ]);

    $this->drupalLogin($this->adminUser);

    $this->drupalGet('/feed/add/' . $feed_type->id());

    $this->assertSession()->pageTextContains('Available Tokens');

    $this->assertSession()->pageTextContains(
      'You can use any of these tokens in text fields and ' .
      'configurations.',
    );

    $this->assertSession()->linkExists('Browse available tokens.');
  }

  /**
   * Tests token browser appears on feed type form.
   */
  public function testTokenBrowserOnFeedTypeForm(): void
  {
    $this->drupalLogin($this->rootUser);

    $this->drupalGet('/admin/structure/feeds/add');

    $this->assertSession()->pageTextContains('Available Tokens');

    $this->assertSession()->pageTextContains(
      'You can use any of these tokens in text fields and ' .
      'configurations.',
    );

    $this->assertSession()->linkExists('Browse available tokens.');
  }

  /**
   * Tests token help section is collapsible.
   */
  public function testTokenHelpIsCollapsible(): void
  {
    $feed_type = $this->createFeedType([
      'fetcher' => 'http',
      'parser' => 'csv',
      'processor' => 'entity:node',
      'processor_configuration' => [
        'values' => ['type' => 'article'],
      ],
    ]);

    $this->drupalLogin($this->adminUser);

    $this->drupalGet('/feed/add/' . $feed_type->id());

    $this->assertSession()->responseContains('Available Tokens');

    $this->assertSession()->elementExists('css', 'details#edit-token-help');
  }

}
