<?php

declare(strict_types=1);

namespace Drupal\Tests\feeds_enhanced_tokens\Kernel;

use Drupal\feeds\Event\FeedsEvents;
use Drupal\feeds\Event\InitEvent;
use Drupal\feeds\FeedInterface;
use Drupal\feeds\FeedTypeInterface;
use Drupal\feeds_enhanced_tokens\EventSubscriber\TokenExpansionSubscriber;
use Drupal\feeds_enhanced_tokens\TokenExpander;
use Drupal\KernelTests\KernelTestBase;

/**
 * Tests the TokenExpansionSubscriber.
 *
 * @group feeds_enhanced_tokens
 * @coversDefaultClass \Drupal\feeds_enhanced_tokens\EventSubscriber\TokenExpansionSubscriber
 */
class TokenExpansionSubscriberTest extends KernelTestBase
{

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'feeds',
    'feeds_enhanced_tokens',
    'token',
    'user',
    'system',
    'field',
    'options',
  ];

  /**
   * The token expander service.
   *
   * @var \Drupal\feeds_enhanced_tokens\TokenExpander
   */
  protected TokenExpander $tokenExpander;

  /**
   * The event subscriber.
   *
   * @var \Drupal\feeds_enhanced_tokens\EventSubscriber\TokenExpansionSubscriber
   */
  protected TokenExpansionSubscriber $subscriber;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void
  {
    parent::setUp();
    $this->installEntitySchema('user');
    $this->installEntitySchema('feeds_feed');
    $this->installEntitySchema('feeds_feed_type');
    $this->installConfig([
      'feeds',
      'feeds_enhanced_tokens',
      'system',
    ]);

    $this->tokenExpander = $this->container->get(
      'feeds_enhanced_tokens.token_expander',
    );
    $this->subscriber = new TokenExpansionSubscriber(
      $this->tokenExpander,
    );
  }

  /**
   * Tests getSubscribedEvents.
   *
   * @covers ::getSubscribedEvents
   */
  public function testGetSubscribedEvents(): void
  {
    $events = TokenExpansionSubscriber::getSubscribedEvents();

    $this->assertArrayHasKey(FeedsEvents::INIT_IMPORT, $events);
    $this->assertArrayHasKey(FeedsEvents::IMPORT_FINISHED, $events);

    $this->assertEquals('onInitImport', $events[FeedsEvents::INIT_IMPORT][0]);
    $this->assertEquals(1000, $events[FeedsEvents::INIT_IMPORT][1]);

    $this->assertEquals(
      'onImportFinished',
      $events[FeedsEvents::IMPORT_FINISHED][0],
    );
    $this->assertEquals(-1000, $events[FeedsEvents::IMPORT_FINISHED][1]);
  }

  /**
   * Tests subscriber service is accessible.
   */
  public function testSubscriberServiceExists(): void
  {
    $this->assertInstanceOf(
      TokenExpansionSubscriber::class,
      $this->subscriber,
    );
  }

}
