<?php

namespace Drupal\feeds_enhanced\Result;

use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\File\FileSystemInterface;
use Drupal\feeds\Result\FetcherResult;

/**
 * Class SftpFetcherResult
 *  Fetcher result for SFTP fetcher.
 *
 * @package Drupal\feeds_enhanced\Result
 */
class SftpFetcherResult extends FetcherResult {
  use DependencySerializationTrait;

  /**
   * {@inheritDoc}
   */
  public function __construct(
    string $file_path,
    protected FileSystemInterface $fileSystem,
  ) {
    parent::__construct($file_path);
  }

  /**
   * {@inheritdoc}
   */
  public function cleanUp(): void {
    if ($this->filePath) {
      $this->fileSystem->unlink($this->filePath);
    }
  }

}
