<?php

namespace Drupal\feeds_enhanced\Feeds\Fetcher\Form;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\feeds\Plugin\Type\ExternalPluginFormBase;
use Drupal\key\KeyRepositoryInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class SftpFetcherForm
 *  The configuration form for SFTP fetchers.
 */
class SftpFetcherForm extends ExternalPluginFormBase implements ContainerInjectionInterface {
  use SftpFetcherFormTrait;

  /**
   * Constructs an SFTP Fetcher form object.
   *
   * @param \Drupal\key\KeyRepositoryInterface $keyRepository
   *   The key repository.
   */
  public function __construct(
    protected KeyRepositoryInterface $keyRepository,
  ) {}

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container): static {
    return new self(
      $container->get('key.repository'),
    );
  }

  /**
   * {@inheritDoc}
   */
  protected function keyRepository(): KeyRepositoryInterface {
    return $this->keyRepository;
  }

  /**
   * {@inheritDoc}
   */
  public function buildConfigurationForm(
    array $form,
    FormStateInterface $form_state,
  ): array {
    return $this->getBaseForm();
  }

  /**
   * {@inheritDoc}
   */
  protected function getConfiguration(string $config_name): mixed {
    return $this->plugin->getConfiguration($config_name);
  }

  /**
   * {@inheritDoc}
   */
  public function submitConfigurationForm(
    array &$form,
    FormStateInterface $form_state,
  ): void {
    // Store the host value as-is (with :port suffix if provided).
    // Parsing happens at runtime after token expansion.
    $config = array_intersect_key(
      $form_state->getValues(),
      $this->getBaseForm(),
    );
    $this->plugin->setConfiguration($config);
  }

}
