<?php

namespace Drupal\feeds_enhanced\Feeds\Fetcher;

use Drupal\feeds\FeedInterface;
use Drupal\feeds\Feeds\Fetcher\HttpFetcher;

/**
 * Class HttpUnconditionalFetcher.
 *
 * @package Drupal\feeds_enhanced\Feeds\Fetcher
 *
 * @FeedsFetcher(
 *   id = "unconditional_http",
 *   title = @Translation("Download unconditionally from url"),
 *   description = @Translation("Downloads data from a URL using Drupal's HTTP request handler. Data will be downloaded even when there has been no change since the last request."),
 *   form = {
 *     "configuration" = "Drupal\feeds\Feeds\Fetcher\Form\HttpFetcherForm",
 *     "feed" = "Drupal\feeds\Feeds\Fetcher\Form\HttpFetcherFeedForm",
 *   }
 * )
 */
class HttpUnconditionalFetcher extends HttpFetcher {

  /**
   * {@inheritDoc}
   */
  protected function getCacheKey(FeedInterface $feed): ?string {
    // Prevent attaching If-None-Match and If-Modified-Since headers so that
    // the target file will always be downloaded.
    // @see \Drupal\feeds\Feeds\Fetcher\HttpFetcher::get()
    // @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/If-Modified-Since
    return FALSE;
  }

}
