<?php

namespace Drupal\feeds_enhanced\Feeds\Target;

/**
 * Enum representing the available target plugins.
 *
 * This enum defines the various target plugins that can be used in the Feeds
 * Enhanced module, providing a type-safe way to reference them.
 */
enum AlternateTargetPlugin: string {
  case BOOK = 'book';
  case BOOLEAN = 'boolean';
  case CONFIG_ENTITY_REFERENCE = 'config_entity_reference';
  case DATERANGE = 'daterange';
  case DATETIME = 'datetime';
  case EMAIL = 'email';
  case ENTITY_REFERENCE = 'entity_reference';
  case FILE = 'file';
  case IMAGE = 'image';
  case INTEGER = 'integer';
  case LINK = 'link';
  case NUMBER = 'number';
  case PASSWORD = 'password';
  case PATH = 'path';
  case STRING = 'string';
  case TELEPHONE = 'telephone';
  case TEXT = 'text';
  case TIMESTAMP = 'timestamp';
  case URI = 'uri';
  case USER_ROLE = 'user_role';

  /**
   * Returns the fully qualified class name for the target plugin.
   *
   * This method maps each enum case to its corresponding class FQDN.
   *
   * @return string
   *   The fully qualified class name of the target plugin.
   */
  public function classFQDN(): string {
    return match($this) {
      self::BOOK => Book::class,
            self::BOOLEAN => Boolean::class,
            self::CONFIG_ENTITY_REFERENCE => ConfigEntityReference::class,
            self::DATERANGE => DateRange::class,
            self::DATETIME => DateTime::class,
            self::EMAIL => Email::class,
            self::ENTITY_REFERENCE => EntityReference::class,
            self::FILE => File::class,
            self::IMAGE => Image::class,
            self::INTEGER => Integer::class,
            self::LINK => Link::class,
            self::NUMBER => Number::class,
            self::PASSWORD => Password::class,
            self::PATH => Path::class,
            self::STRING => StringTarget::class,
            self::TELEPHONE => Telephone::class,
            self::TEXT => Text::class,
            self::TIMESTAMP => Timestamp::class,
            self::URI => Uri::class,
            self::USER_ROLE => UserRole::class,
    };
  }

  /**
   * Returns the string value of the enum case.
   *
   * @return string
   *   The string value.
   */
  public function toString(): string {
    return $this->value;
  }

}
