<?php

namespace Drupal\feeds_enhanced\Feeds\Parser\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\feeds\Plugin\Type\ExternalPluginFormBase;
use Drupal\feeds_enhanced\Feeds\Parser\IniParser;

/**
 * Class IniParserForm
 *  Defines a form for configuring the Feed Type options for the INI parser.
 *
 * @package Drupal\feeds_enhanced\Feeds\Parser\Form
 */
class IniParserForm extends ExternalPluginFormBase {

  /**
   * {@inheritDoc}
   */
  public function buildConfigurationForm(
    array $form,
    FormStateInterface $form_state,
  ): array {
    $form['options_details'] = [
      '#type' => 'details',
      '#title' => $this->t('INI file parse options'),
      '#description' => $this->t('<strong>This INI parser version only supports one entity per file.</strong>'),
      '#open' => TRUE,

      IniParser::getMultiModeKey() => [
        '#type' => 'checkbox',
        '#title' => $this->t('Multiple Entities'),
        '#description' => $this->t('Select this option to allow multiple entities to be read from the fetched file, as INI file sections. See the <strong>process_sections</strong> argument in <a href="https://www.php.net/manual/en/function.parse-ini-file.php" target="_blank">parse_ini_file()</a> for more information.'),
        '#disabled' => TRUE,
        '#default_value' => $this->plugin
          ->getConfiguration(IniParser::getMultiModeKey()),
      ],
    ];
    return $form;
  }

}
