<?php

namespace Drupal\feeds_enhanced\Feeds\Target;

/**
 * Interface FeedTargetSupportMultiValueInterface.
 *  Defines an interface for feed targets that support multiple values.
 */
interface FeedTargetSupportMultiValueInterface {

  /**
   * Returns a value that specifies whether this Feeds target supports
   * collecting multiple values.
   *
   * @return bool
   *   TRUE if the target supports multiple values, FALSE otherwise.
   */
  public function supportsMultiValue(): bool;

  /**
   * Returns the name of the configuration property that is used to determine
   * whether this Feeds target supports collecting multiple values.
   *
   * @return string
   */
  public static function multiValuePropertyName(): string;

}
