# Changelog

All notable changes to Feeds Enhanced will be documented in this file.

## [1.0.0-beta5] - 2026-01-08

### Fixed
- **Critical: Token Persistence Issue** - Tokens in feed configuration
  now remain unexpanded after import. Previously, tokens like
  `127.0.0.1:[pantheon_si_tunnel:port]` were being persisted as
  expanded values (e.g., `127.0.0.1:40000`) after feed execution,
  breaking dynamic port functionality.
  - Token expansion now happens at runtime in SftpFetcher::fetch()
  - Event subscriber no longer expands feed-level config to prevent
    persistence
  - Tokens stay in database unexpanded, expand fresh on each import

### Added
- Token service injection into SftpFetcher for runtime token expansion
  - Nullable Token service for backward compatibility
  - Proper dependency injection via constructor and create() method
- Comprehensive test coverage for token persistence behavior
  - SftpFetcherTokenPersistenceTest verifies tokens remain unexpanded
  - TokenExpansionSubscriberTest validates no feed-level persistence
  - Tests for Token service injection
- GitLab CI configuration (.gitlab-ci.yml) for automated testing

### Changed
- Token expansion moved from event subscriber to SftpFetcher
- Logger service properly injected into TokenExpansionSubscriber
  (replaced static \Drupal::logger() calls)

## [1.0.0-beta4] - 2025-01-06

### Changed
- **SFTP Fetcher**: Refactored to use `hostname:port` format in Host field instead of separate Port field
  - Port defaults to 22 if omitted
  - Enables token support for dynamic port numbers (e.g., `127.0.0.1:[pantheon_si_tunnel:port]`)
  - Host value is stored as-is (combined string) and parsed at runtime after token expansion
  - Backward compatible with existing configurations

### Fixed
- Added missing `options` module dependency to Kernel tests
- Updated MockSftpClient in functional tests to implement `defaultPort()` method
- Runtime token expansion now correctly extracts port from expanded tokens

## [1.0.0-beta3] - 2025-01-06

### Added
- New submodule: **Feeds Enhanced - Token Support**
  - Universal token expansion for all Feeds text fields and configurations
  - Automatic integration via event subscriber (INIT_IMPORT @ priority 1000)
  - Session-based caching for performance optimization
  - Support for any Drupal token (feed, feed-type, current-user, date, site, custom tokens)
  - Token browser on Feed and Feed Type forms for easy token discovery
  - Requires Token module for full functionality
  - Addresses community issues [#3131079](https://www.drupal.org/project/feeds/issues/3131079) and [#3282260](https://www.drupal.org/project/feeds/issues/3282260)

### Changed
- feeds_enhanced_tokens now requires Token module (hard dependency)
- feeds_enhanced_tokens no longer depends on feeds_enhanced (only feeds + token)

### Documentation
- Comprehensive README for feeds_enhanced_tokens with usage examples
- Examples include dynamic SFTP paths, Pantheon SI tunnel integration, user-specific sources

## [1.0.0-beta1] - 2025-07-14

### Added
- Initial beta release
- SFTP Fetcher for secure file transfers using key-based authentication
- HTTP Unconditional Fetcher for downloading feeds without conditional GET restrictions
- Null Data Source for programmatic feed data
- INI Parser for processing INI-formatted feed files
- Entity Data Parser for direct entity data parsing
- Enhanced Content Entity Processor with improved functionality
- Multiple enhanced target plugins for various field types

### Notes
- This is the first public beta release after successful private production use
- APIs may still undergo minor changes based on community feedback
