<?php

namespace Drupal\feeds_enhanced\Feeds\Fetcher;

use Drupal\feeds\FeedInterface;
use Drupal\feeds\Plugin\Type\Fetcher\FetcherInterface;
use Drupal\feeds\Plugin\Type\PluginBase;
use Drupal\feeds\Result\FetcherResult;
use Drupal\feeds\Result\FetcherResultInterface;
use Drupal\feeds\StateInterface;

/**
 * Class NullDataSource
 *  Performs no data fetching and returns a FetcherResult() pointing to an
 *  empty string. This parser is useful for update-only Feed types, where no
 *  new data will be imported.
 *
 * @package Drupal\feeds_enhanced\Feeds\Fetcher
 *
 * @FeedsFetcher(
 *   id = "null_data_source",
 *   title = @Translation("Null data source"),
 *   description = @Translation("No external data are retrieved."),
 *   form = {
 *     "configuration" = "Drupal\feeds_enhanced\Feeds\Fetcher\Form\NullDataSourceFetcherForm",
 *     "feed" = "Drupal\feeds_enhanced\Feeds\Fetcher\Form\NullDataSourceFeedForm",
 *   },
 * )
 */
class NullDataSource extends PluginBase implements FetcherInterface {

  /**
   * {@inheritDoc}
   */
  public function fetch(
    FeedInterface $feed,
    StateInterface $state,
  ): FetcherResultInterface {
    return new FetcherResult('');
  }

}
