# Feeds HTTP OAuth Fetcher

## Overview

`feeds_http_oauth` provides an OAuth 2.0–enabled HTTP fetcher for the
[Feeds](https://www.drupal.org/project/feeds) module (Feeds 3.x).

This module adds a **new fetcher plugin**:

> **Download from url (OAuth 2.0)**

It allows Feeds to retrieve data from OAuth-protected HTTP endpoints while
preserving all existing core HTTP fetcher behavior.

This module does **not** patch or modify Feeds core.

---

## Background / Why this module exists

This functionality originally began as a merge from the contrib feeds module issue:
https://www.drupal.org/project/feeds/issues/3030847

It modified the core HTTP Fetcher to add Oauth 2.0 functionality.

That approach proved problematic for several reasons:

- It overloaded the core HTTP fetcher with authentication concerns
- It mixed feed-type configuration and per-feed credentials
- It introduced OAuth-specific schema and UI into all HTTP feeds
- It created long-term maintenance and upstreaming challenges
- It increased the security surface area of a simple fetcher

After review, the OAuth logic was extracted and re-implemented here as a **separate
fetcher plugin**, which aligns with Feeds’ plugin architecture and separation
of concerns.

This module is the result of that refactor.

---

## Design philosophy

This module follows a **thin extension** model:

- It **extends** Feeds’ core `HttpFetcher`
- It **reuses** the core HTTP fetcher configuration form
- It **injects OAuth headers at request time only**
- It keeps OAuth credentials **per feed**, not per feed type
- It avoids duplicating or forking core Feeds logic

In other words:

> This is the core HTTP fetcher, plus OAuth headers — nothing more.

---

## What this module does

- Adds a new Feeds fetcher: **Download from url (OAuth 2.0)**
- Supports OAuth 2.0 token acquisition, currently:
  - `client_credentials`
  - `password` grant
- Injects the resulting `Authorization` header into HTTP requests
- Preserves all existing HTTP fetcher features:
  - Caching
  - Conditional requests
  - Timeouts
  - Always-download behavior
- Keeps OAuth configuration scoped to individual feed instances

---

## What this module does NOT do

- It does **not** modify or override the core HTTP fetcher
- It does **not** add OAuth toggles to existing fetchers
- It does **not** store credentials globally
- It does **not** implement refresh-token caching (yet)
- It does **not** attempt to normalize provider-specific OAuth quirks

---

## Requirements

- Drupal 10 or 11
- Feeds 3.x

## Enabling

1. set a feed type to use the new fetcher "Download from url (OAUTH 2.0)
2. Configure the standard HTTP fetcher options as needed:
  - Request timeout
  -  Always download
  - (Optional) Auto detect feeds
  - (Optional) PubSubHubbub
3. Create or edit a Feed entity of the above feed type
  - Enter the **Source URL** (the protected API endpoint)
  - Configure OAuth settings:
  - Access Token URL
  - Grant type
  - Client ID
  - Client Secret
  - Scope (optional)
  - Username / Password (password grant only)
    Run the feed

When the feed runs:

1. An access token is requested from the configured token endpoint
2. The token is added to the HTTP request as an `Authorization` header
3. The feed is fetched using Feeds’ normal HTTP handling
4. Parsing and processing proceed as usual

If token acquisition fails, the feed will fail gracefully.

NOTE: Secrets are only saved when explicitly entered. Leaving secret fields blank
will preserve existing values.

---

## Security notes

- OAuth credentials are stored per feed, not globally
- Secrets are not overwritten unless explicitly re-entered
- No credentials are added to Feeds core configuration
- Token handling is intentionally minimal in v1

For more advanced credential handling, integration with the Key module may be
added in the future.
