<?php

namespace Drupal\feide_login\Plugin\KeyType;

use Drupal\key\Plugin\KeyType\AuthenticationMultivalueKeyType;

/**
 * Defines a key that stores Graph API connection information.
 *
 * The underlying key is serialized into JSON format.
 *
 * @KeyType(
 *   id = "feide_login",
 *   label = @Translation("Feide credentials"),
 *   description = @Translation("Stores a public and private key required to authenticate with Feide."),
 *   group = "connection_string",
 *   key_value = {
 *     "plugin" = "feide_login_input",
 *   },
 *   multivalue = {
 *     "enabled" = true,
 *     "fields" = {
 *       "client_id" = {
 *         "label" = @Translation("Client ID"),
 *         "required" = true
 *       },
 *       "client_secret" = {
 * *         "label" = @Translation("Client secret"),
 * *         "required" = true
 * *       },
 *       "redirect_uri" = {
 * *         "label" = @Translation("Redirect URI"),
 * *         "required" = true
 * *       },
 *     }
 *   }
 * )
 */
class FeideKeyType extends AuthenticationMultivalueKeyType {

}
