<?php

namespace Drupal\feide_login\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;


/**
 * Form to handle tokens and such.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'feide_login_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function getEditableConfigNames() {
    return ['feide_login.settings'];
  }

  /**
   * The form.
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('feide_login.settings');

    $form['register_users'] = [
      '#type' => 'checkbox',
      '#title' => 'Register users',
      '#default_value' => $config->get('register_users'),
      '#description' => $this->t('Should users be created on successful auth.'),
    ];
    $form['link_accounts'] = [
      '#type' => 'checkbox',
      '#title' => 'Link existing accounts',
      '#default_value' => $config->get('link_accounts'),
      '#description' => $this->t('Connect existing accounts if things match.'),
    ];
    $form['show_on_user_login'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Show Feide login link on /user/login'),
      '#default_value' => $config->get('show_on_user_login'),
      '#description' => $this->t('If checked, a Feide login link will be shown on the standard Drupal login page.'),
    ];
    $form['hide_normal_login'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Hide normal login form on /user/login'),
      '#default_value' => $config->get('hide_normal_login'),
      '#description' => $this->t('If checked, the normal Drupal login form will be hidden and only the Feide login link will be shown.'),
    ];
//    $form['client_id'] = [
//      '#type' => 'textfield',
//      '#title' => $this->t('Client ID'),
//      '#default_value' => $config->get('client_id'),
//    ];
    // Set the key repo from Key module
    $form['key_repo'] = [
      '#type' => 'key_select',
      '#key_filters' => ['type' => 'feide_login'],
      '#title' => $this->t('Key repository'),
      '#default_value' => $config->get('key_repo'),
      '#required' => TRUE,
      '#key_description' => FALSE,
      '#description' => $this->t('Choose an available key. If the desired key is not listed, <a href=":link">create a new key</a> of type "Feide credentials".',
        [':link' => Url::fromRoute('entity.key.add_form')->toString()]),
    ];
//    $form['redirect_uri'] = [
//      '#type' => 'textfield',
//      '#title' => $this->t('Redirect URI'),
//      '#default_value' => $config->get('redirect_uri'),
//    ];
    $form['debug'] = [
      '#type' => 'checkbox',
      '#title' => 'Debug',
      '#default_value' => $config->get('debug'),
      '#description' => $this->t('Log debug messages'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $config = $this->config('feide_login.settings');

//    $config->set('client_id', $form_state->getValue('client_id'));
    $config->set('key_repo', $form_state->getValue('key_repo'));
//    $config->set('redirect_uri', $form_state->getValue('redirect_uri'));
    $config->set('register_users', $form_state->getValue('register_users'));
    $config->set('link_accounts', $form_state->getValue('link_accounts'));
    $config->set('debug', $form_state->getValue('debug'));
    $config->set('show_on_user_login', $form_state->getValue('show_on_user_login'));
    $config->set('hide_normal_login', $form_state->getValue('hide_normal_login'));
    $config->save();
  }

}
