<?php

namespace Drupal\Tests\field_access\Unit;

class NodeTestPermissionMap {

  const __DEFAULT = [
    'created' => TRUE,
    'changed' => [
      'view' => TRUE,
      'create' => FALSE,
    ],
  ];

  const PAGE = [
    'uid' => ['content_editor'],
    'status' => ['administer content'],
    'changed' => FALSE,
    'title' => [
      'view' => TRUE,
      'create' => ['content_editor'],
    ],
    'body' => [
      'view' => FALSE,
      'create' => ['content_editor'],
    ],
  ] + self::__DEFAULT;

  const POST = [
    'created' => [
      'view' => '/a-regex-pattern/',
      'create' => FALSE,
      'edit' => TRUE,
    ],
    'changed' => '/a-regex-pattern/',
    'status' => [
      'view' => ['administer content'],
      'create' => ['content_editor'],
      'edit' => ['administer content', 'content_editor'],
    ],
  ] + self::__DEFAULT;

}
