<?php

declare(strict_types=1);

namespace Drupal\field_encrypt\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Update\UpdateHookRegistry;

/**
 * Update requirements for field_encrypt.
 */
class FieldEncryptRequirementsHook {
  use StringTranslationTrait;

  public function __construct(protected UpdateHookRegistry $updateHookRegistry) {
  }

  /**
   * Checks whether the site meets the module requirements.
   */
  private function requirementsCheck(): array {
    $requirements = [];
    $schema = $this->updateHookRegistry->getInstalledVersion('field_encrypt');

    if ((int) $schema < 8300) {
      $requirements['field_encrypt_update_to_v4'] = [
        'title' => $this->t('Field Encrypt'),
        'severity' => REQUIREMENT_ERROR,
        'value' => $this->t('Updating to field_encrypt version 4 is not supported.'),
        'description' => $this->t('In order to upgrade you need to decrypt all your data on the previous version and uninstall the module.'),
      ];
    }
    return $requirements;
  }

  /**
   * Implements hook_update_requirements().
   */
  #[Hook('update_requirements')]
  public function update(): array {
    return $this->requirementsCheck();
  }

  /**
   * Implements hook_runtime_requirements().
   */
  #[Hook('runtime_requirements')]
  public function runtime(): array {
    return $this->requirementsCheck();
  }

}
