<?php

declare(strict_types=1);

namespace Drupal\Tests\field_encrypt\Functional;

use Drupal\Core\Url;
use Drupal\Tests\RequirementsPageTrait;

/**
 * Tests that updating from older versions of field encrypt is not supported.
 *
 * @group field_encrypt
 * @group legacy
 */
class FieldEncryptUpdatePathTest extends FieldEncryptTestBase {
  use RequirementsPageTrait;

  /**
   * URL to the update.php script.
   *
   * @var string
   */
  private string $updateUrl;

  /**
   * @var string
   */
  private string $fieldEncryptCannotUpdateMessage = 'Updating to field_encrypt version 4 is not supported.';

  /**
   * @var string
   */
  private string $drupalCoreCannotUpdateMessage = 'The installed version of the Field Encrypt module is too old to update.';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->updateUrl = Url::fromRoute('system.db_update')->toString();
  }

  /**
   * Tests field_encrypt_requirements().
   */
  public function testUpdate(): void {
    $this->drupalLogin($this->rootUser);
    $this->drupalGet($this->updateUrl, ['external' => TRUE]);
    $this->updateRequirementsProblem();
    $this->clickLink('Continue');
    $this->assertSession()->pageTextContains('No pending updates.');

    // Simulate having an old version of field_encrypt.
    \Drupal::service('update.update_hook_registry')->setInstalledVersion('field_encrypt', 8000);
    $this->drupalGet($this->updateUrl, ['external' => TRUE]);
    $this->assertThat($this->getTextContent(),
      $this->logicalOr(
        // 11.2+.
        $this->stringContains($this->drupalCoreCannotUpdateMessage),
        // Before 11.2.
        $this->stringContains($this->fieldEncryptCannotUpdateMessage),
      ));

    $this->drupalGet('admin/reports/status');
    $this->assertSession()->pageTextContains($this->fieldEncryptCannotUpdateMessage);
  }

}
