<?php

declare(strict_types=1);

namespace Drupal\field_encrypt;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Drupal\Core\Hook\Order\Order;

/**
 * Adds and orders hooks to ensure entities are decrypted before use.
 */
class FieldEncryptServiceProvider extends ServiceProviderBase {

  const string METHOD_NAME = 'decryptEntity';

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container): void {
    $field_encrypt_entity_types = $container->get('keyvalue')
      ->get('field_encrypt')
      ->get('entity_types', []);
    $container->getDefinition('field_encrypt.state_manager')->setArgument('$entityTypes', $field_encrypt_entity_types);
    $container->setParameter('field_encrypt.entity_types', $field_encrypt_entity_types);

    if (!empty($field_encrypt_entity_types)) {
      $order = Order::First;
      $map = $container->getParameter('.hook_data');
      $definition = $container->findDefinition('field_encrypt.process_entities');
      $identifier = $definition->getClass() . ':' . self::METHOD_NAME;
      foreach ($field_encrypt_entity_types as $entity_type) {
        $hooks = [
          "{$entity_type}_insert",
          "{$entity_type}_update",
        ];
        foreach ($hooks as $hook) {
          // Ensure the hook comes first.
          $map['hook_list'][$hook] = [$identifier => 'field_encrypt'] + ($map['hook_list'][$hook] ?? []);

          // Add the packed order operation for consistency.
          if (!isset($map['packed_order_operations'][$hook])) {
            $map['packed_order_operations'][$hook] = [];
          }
          array_unshift($map['packed_order_operations'][$hook], $order->getOperation($identifier)->pack());
        }
      }
      $container->setParameter('.hook_data', $map);
    }
  }

}
