# Contributing

Thanks for your interest in contributing!

## Getting Started

This project uses [DDEV](https://ddev.com) with
[`ddev-drupal-contrib`](https://github.com/drupal/ddev-drupal-contrib) for local
development and testing.

### Requirements

- [DDEV](https://ddev.readthedocs.io/en/stable/)

### Setup

1. Clone the module project:

```sh
git clone https://git.drupalcode.org/project/field_group_complete.git
cd field_group_complete
````

2. Start DDEV and provision Drupal:

```sh
ddev start
ddev poser
```

> `ddev poser` will download Drupal via a transient `composer.contrib.json`,
> configure testing scaffolding, and prepare the site.

3. Symlink your module into the testing site:

```sh
ddev symlink-project
```

> This ensures the module code is symlinked at
> `web/modules/custom/field_group_complete`.

4. Launch the site:

```sh
ddev launch
```

Install site with:

```sh
ddev drush site:install --account-name=admin --account-pass=admin -y
ddev drush en field_group_complete -y
```

Log in with:

* **Username**: `admin`
* **Password**: `admin`

Or with:

```sh
ddev launch $(ddev drush user:login)
```

## Running Tests

To run all tests:

```sh
ddev phpunit
```

## Coding Standards

Ensure your code follows the [Drupal Coding Standards](https://www.drupal.org/docs/develop/standards):

```sh
ddev phpcs --basepath=./web/modules/custom/field_group_complete --standard=Drupal --extensions=php,module,inc,install,test,profile,theme,css,info,txt,md,yml --ignore='*/.ddev/*'  --ignore='*/vendor/*'
```

To auto-fix coding issues:

```sh
ddev phpcbf --basepath=./web/modules/custom/field_group_complete --standard=Drupal --extensions=php,module,inc,install,test,profile,theme,css,info,txt,md,yml --ignore='*/.ddev/*'  --ignore='*/vendor/*'
```

## Running Drupal 10 or 11

Easily switch core version with:

```sh
ddev core-version ^10
ddev core-version ^11
```

## Getting Help

Need help? Drop a comment in the [issue queue](https://www.drupal.org/project/issues/field_group_complete).
