# Field Group Complete

Adds a live **completion indicator** to Field Group **tab labels** (and panes).
When every **visible, enabled, currently-required** control inside a pane is
satisfied, the module toggles a class on the **tab item** and (optionally) shows
an accessible badge.

- **ROP-friendly**: reacts to “required on publish” state changes.
- **Conditional Fields-friendly**: respects dynamic visibility/required.
- **No per-form wiring**: auto-detects Field Group panes.
- **Class-driven**: design systems style against the provided classes.
- **A11y option**: badge can be visible, screen-reader-only, or disabled.

## What it looks like

On a form with Field Group Tabs:
- The **tab’s `<li>` / `<a>`** gets `field-group-complete--complete` when its
  pane is complete.
- You may add your own classes (e.g., `usa-check`) via settings.
- An optional badge on the tab label announces “Complete/Incomplete.”

## Install

1. Enable **Field Group** and this module.
2. Clear caches.

That’s it — defaults work out of the box for common Tab/Accordion/Details
wrappers produced by Field Group.

## Configuration

Go to **Configuration → Content authoring → Field Group Complete**
Path: `/admin/config/content/field-group-complete`

- **Extra complete-classes**: one per line. These are applied to the **tab**
  when complete (e.g., `usa-check`, `my-ds--complete`).
- **Badge text (complete / incomplete)**: customizable and translatable (via
  Config Translation).
- **Badge visibility**:
  - **Visible (default)** — show badge text on the tab.
  - **Screen reader only** — visually hidden but announced via `aria-live="polite"`.
  - **No badge** — classes only; style via your design system.

## Theming / Classes

Applied automatically:

- On **tab `<li>` or `<a>`** (primary UX target):
  - `field-group-complete--enhanced`
  - `field-group-complete--complete` (while complete)
  - Custom classes from config (e.g., `usa-check`)
- On **pane `<details>`** (optional theming hook):
  - `field-group-complete--enhanced`
  - `field-group-complete--complete`
  - `data-field-group-complete` (boolean attribute)

Badge elements (only if enabled):
- `.field-group-complete__badge`
- `.field-group-complete__badge-text`

Tip: If you don’t want a badge at all, set **Badge visibility** to **No badge**,
and style against `.field-group-complete--complete` on the tab.

## Accessibility

- Badge updates are announced to assistive tech via `aria-live="polite"`.
- “Screen reader only” uses Drupal’s `visually-hidden` utility.
- No focus stealing; status updates are passive.

## How it works

- Discovers Field Group **leaf wrappers** (tab panes / accordion items / details).
- Observes descendant inputs for visibility, enabled state, required signals,
  and values (including radios/checkbox groups).
- Recomputes on `input`, `change`, and attribute mutations (`required`,
  `aria-required`, `disabled`, `class`, `style`, `hidden`).

## Compatibility

- **Drupal Core**: 10 or 11
- **Requires**: [Field Group](https://www.drupal.org/project/field_group)
- **Works with**:
  - [Require on Publish](https://www.drupal.org/project/require_on_publish)
  - [Conditional Fields](https://www.drupal.org/project/conditional_fields)

> The module is client-side only. It does not change validation or submission
> logic.

## Roadmap / Ideas

- Optional “X/Y complete” counters.
- Webform adapter (if demand exists).

## Contributing / Support

PRs and issues welcome on the project issue queue. If you need enhancements or
support, please consider sponsoring development.
