<?php

namespace Drupal\Tests\field_group_complete\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the Field Group Complete settings form.
 *
 * @group field_group_complete
 */
class SettingsFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['field_group_complete', 'system'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Test field group complete settings form.
   */
  public function testFieldGroupCompleteSettingsFormSaves() {
    $admin = $this->drupalCreateUser(['administer site configuration']);
    $this->drupalLogin($admin);

    $this->drupalGet('/admin/config/content/field-group-complete');
    $this->assertSession()->statusCodeEquals(200);

    $edit = [
      'custom_complete_classes' => "usa-check\nmy-lib--complete",
      'badge_text_complete' => 'All set',
      'badge_text_incomplete' => 'Needs work',
      'badge_visibility' => 'sr-only',
    ];
    $this->submitForm($edit, 'Save configuration');
    $this->assertSession()->pageTextContains('The configuration options have been saved');

    $config = $this->container->get('config.factory')->get('field_group_complete.settings');
    $this->assertEquals(['usa-check', 'my-lib--complete'], $config->get('custom_complete_classes'));
    $this->assertEquals('All set', $config->get('badge_text_complete'));
    $this->assertEquals('Needs work', $config->get('badge_text_incomplete'));
    $this->assertEquals('sr-only', $config->get('badge_visibility'));
  }

}
