<?php

namespace Drupal\field_inheritance\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The FieldInheritance attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class FieldInheritance extends Plugin {

  /**
   * Constructs a FieldInheritance attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $name
   *   The name of the form plugin.
   * @param array $types
   *   An array of field types the inheritance plugin supports.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $name,
    public readonly array $types = [],
  ) {}

}
