<?php

namespace Drupal\field_inheritance;

use Drupal\Core\Field\EntityReferenceFieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

/**
 * The EntityReferenceFieldInheritanceFactory class.
 *
 * Note: This class exists separately to the FieldInheritanceFactor because
 * when inheriting data from an entity_reference field we end up with type hints
 * failing during calls to EntityReferenceFormatterBase::getEntitiesToView().
 */
class EntityReferenceFieldInheritanceFactory extends EntityReferenceFieldItemList {

  use ComputedItemListTrait;
  use FieldInheritanceFactoryTrait {
    FieldInheritanceFactoryTrait::setValue insteadof ComputedItemListTrait;
  }

}
