<?php

namespace Drupal\field_login\Plugin\FieldLogin;

use Drupal\field_login\FieldLoginPluginBase;

/**
 * Plugin implementation of the field_login.
 *
 * @FieldLogin(
 *   id = "phone",
 *   label = @Translation("Phone field"),
 *   description = @Translation("Phone field description."),
 *   field_name="field_phone"
 * )
 */
class PhoneField extends FieldLoginPluginBase {

  /**
   * Query User UID.
   *
   * @param $inputValue
   *  The value passed in by the user login form.
   *
   * @return array
   */
  public function getAccountUid($inputValue): array {
    return \Drupal::entityQuery('user')
      ->accessCheck()
      ->condition('field_phone.local_number', $inputValue)
      ->execute();
  }

}
