<?php

namespace Drupal\field_login\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines field_login annotation object.
 *
 * @Annotation
 */
class FieldLogin extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The description of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * Field name for user login.
   *
   * @var string
   */
  public $field_name;

  /**
   * Field type for user login.
   *
   * @var string
   */
  public $field_type;

}
