<?php

namespace Drupal\field_login;

use Drupal\user\UserAuthInterface;
use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\user\UserStorageInterface;

/**
 * Validates user authentication credentials.
 */
class UserAuthDecorator implements UserAuthInterface {

  use DependencySerializationTrait;

  /**
   * The original user authentication service.
   *
   * @var \Drupal\user\UserAuthInterface
   */
  protected UserAuthInterface $userAuth;

  /**
   * The user storage.
   *
   * @var \Drupal\user\UserStorageInterface
   */
  protected UserStorageInterface $userStorage;

  /**
   * Constructs a UserAuth object.
   *
   * @param \Drupal\user\UserAuthInterface $user_auth
   *   The original user authentication service.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager service.
   */
  public function __construct(UserAuthInterface $user_auth, EntityTypeManagerInterface $entity_type_manager) {
    $this->userAuth = $user_auth;
    $this->userStorage = $entity_type_manager->getStorage('user');
  }

  /**
   * {@inheritdoc}
   */
  public function authenticate($inputValue, $password): bool|int {
    $username = $inputValue;

    $fieldLoginPlugin = \Drupal::service('plugin.manager.field_login');
    $login_field = \Drupal::configFactory()
      ->get('field_login.settings')
      ->get('login_field');

    // Hook Field Login.
    $hook = 'field_login';
    foreach ($login_field as $field) {
      $loginName = $field === 'mail' ? filter_var($inputValue, FILTER_VALIDATE_EMAIL) : $inputValue;

      // Plugin Query User ID.
      if (!empty($fieldLoginPlugin->hasFieldLoginPlugin($field))) {
        $uid = $fieldLoginPlugin->getFieldLoginPlugin($field, $inputValue);
      }

      // HOOK Query User ID.
      if (\Drupal::moduleHandler()->hasImplementations($hook) &&
        $hook_uid = \Drupal::moduleHandler()->invokeAll($hook, [
          $field,
          $inputValue,
        ])) {
        $uid = $hook_uid;
      }

      if ($query_uid = $this->userStorage->getQuery()
        ->accessCheck()
        ->condition($field, $loginName)
        ->execute()) {
        $uid = $query_uid;
      }

      if (!empty($uid)) {
        $entities = $this->userStorage->loadMultiple($uid);
        foreach ($entities as $account) {
          $username = $account->getAccountName();
        }
      }
    }

    return $this->userAuth->authenticate($username, $password);
  }

}
