<?php

namespace Drupal\field_login;

use Drupal\Core\Password\PasswordInterface;
use Drupal\user\UserAuthInterface;
use Drupal\user\UserAuthenticationInterface;

/**
 * Validates user authentication credentials.
 */
class UserAuthDecorator implements UserAuthInterface {

  /**
   * The original user authentication service.
   *
   * @var \Drupal\user\UserAuthInterface
   */
  protected $userAuth;

  /**
   * The password hashing service.
   *
   * @var PasswordInterface
   */
  protected $passwordChecker;

  /**
   * The user storage.
   *
   * @var UserVerificationInterface
   */
  protected $userVerification;

  /**
   * Constructs a UserAuth object.
   *
   * @param UserAuthenticationInterface $user_auth
   *   The original user authentication service.
   * @param UserVerificationInterface $user_verification
   *   This provide user authentication services.
   */
  public function __construct(UserAuthenticationInterface $user_auth, PasswordInterface $password_checker, UserVerificationInterface $user_verification) {
    $this->userAuth = $user_auth;
    $this->passwordChecker = $password_checker;
    $this->userVerification = $user_verification;
  }

  /**
   * {@inheritdoc}
   */
  public function authenticate($username, #[\SensitiveParameter] $password) {
    $uid = FALSE;
    if (!empty($username) && strlen($password) > 0) {
      if ($account = $this->userVerification->validate($username)) {
        if ($this->userAuth->authenticate($account->getAccountName(), $password)) {
          $uid = $account->id();
        }
      }
    }

    return $uid;
  }

}
