<?php

declare(strict_types=1);
namespace Drupal\field_login_simple_oauth\Repository;

use Drupal\simple_oauth\Entities\UserEntity;
use Drupal\user\UserAuthenticationInterface;
use League\OAuth2\Server\Entities\UserEntityInterface;

/**
 * The user repository.
 */
final class UserRepository implements UserRepositoryInterface {

  /**
   * @param \Drupal\user\UserAuthenticationInterface $userAuth
   */
  public function __construct(
    protected UserAuthenticationInterface $userAuth,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getUserEntityByUserCredentials($username, $password): ?UserEntityInterface {
    if ($account = $this->userAuth->lookupAccount($username)) {
      $auth_status = $this->userAuth->authenticateAccount($account, $password);
      if ($auth_status) {
        $user = new UserEntity();
        $user->setIdentifier($account->id());

        return $user;
      }
    }

    return NULL;
  }

}
