<?php

namespace Drupal\field_login_simple_oauth\Repository;

use League\OAuth2\Server\Entities\UserEntityInterface;
use League\OAuth2\Server\Repositories\RepositoryInterface;

/**
 * Interface UserRepositoryInterface.
 */
interface UserRepositoryInterface extends RepositoryInterface {

  /**
   * Get a user entity.
   *
   * @param string $username
   * @param string $password
   *
   * @return UserEntityInterface|null
   */
  public function getUserEntityByUserCredentials(string $username, string $password): ?UserEntityInterface;

}
