<?php

declare(strict_types=1);

namespace Drupal\field_redirect\Hook;

use Drupal\Core\Entity\Display\EntityViewDisplayInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\field_redirect\Service\Utility;

/**
 * Entity hooks class.
 */
final class EntityHooks {

  public function __construct(private Utility $utility) {}

  /**
   * Implements hook_entity_view_alter().
   */
  #[Hook('entity_view_alter')]
  public function viewAlter(array &$build, EntityInterface $entity, EntityViewDisplayInterface $display): void {
    if ($display->getOriginalMode() === 'full') {
      // Disable the cache, because redirect must be success always.
      $build['#cache']['max-age'] = 0;
      $this->utility->doRedirect('view', $entity);
    }
  }

}
