# Field Redirect Module

## Overview

This module can redirect to field values for "link", "file", or "image"
field types contained in "user", "node", "taxonomy term", or
return "403 Forbidden" or "404 Not Found".
For redirects, you can specify the status code "301 Moved Permanently",
"302 Found", "303 See Other", and "307 Temporary Redirect".
(*The default is "307 Temporary Redirect", if not specified.)

## How to configuration:

Just one text area in configuration page:

``your-drupal-site-domain/admin/config/search/field-redirect``.

### Example 1:

``node:article|field_source_url#301,#403``

Redirect to URL as "301 Moved Permanently" status, if entity type "node",
if bundle "article", and if "field_source_url" is entered.
Return "403 Forbidden" status, if "field_source_url" is not entered.

### Example 2:

``node:page|#404``

Return "404 Not Found" status, if entity type "node", and if bundle "page".
This is mainly for when you don't want to show the details page.

### Example 3:

``taxonomy_term:*|field_overview_url,field_wiki_url``

Redirect to URL as "307 Temporary Redirect" status, if entity type
"taxonomy_term", if vocabulary is all, and if "field_overview_url" is entered.

Redirect to URL as "307 Temporary Redirect" status, if "field_overview_url"
is not entered, and if "field_wiki_url" is entered.
Display "taxonomy_term" normal, if "field_wiki_url" is also not entered.

### Example 4:

``user|field_sns_url``

Redirect to URL as "307 Temporary Redirect" status, if entity type "user",
and if "field_sns_url" is entered. Display "user" normal if "field_sns_url"
is not entered.

_ _ _

If you enter the above in textarea of the config form, it will look like this:

```
node:article|field_source_url#301,#403
node:page|#404
taxonomy_term:*|field_overview_url,field_wiki_url
user|field_sns_url
```
