<?php

declare(strict_types=1);

namespace Drupal\field_redirect\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\field_redirect\Service\Utility;

/**
 * Form hooks class.
 */
final class FormHooks {

  public function __construct(private Utility $utility) {}

  /**
   * Implements hook_form_BASE_FORM_ID_alter().
   */
  #[Hook('form_node_form_alter')]
  public function nodeFormAlter(array &$form, FormStateInterface $form_state, string $form_id): void {
    $this->utility->formAlter($form, $form_state, $form_id);
  }

  /**
   * Implements hook_form_BASE_FORM_ID_alter().
   */
  #[Hook('form_taxonomy_term_form_alter')]
  public function taxonomyTermFormAlter(array &$form, FormStateInterface $form_state, string $form_id): void {
    $this->utility->formAlter($form, $form_state, $form_id);
  }

  /**
   * Implements hook_form_BASE_FORM_ID_alter().
   */
  #[Hook('form_user_form_alter')]
  public function userFormAlter(array &$form, FormStateInterface $form_state, string $form_id): void {
    $this->utility->formAlter($form, $form_state, $form_id);
  }

}
