<?php

declare(strict_types=1);

namespace Drupal\field_redirect\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Help hook class.
 */
final class HelpHook {

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help(string $route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.field_redirect':
        if ($output = @\file_get_contents(dirname(__DIR__, 2) . DIRECTORY_SEPARATOR . 'README.md')) {
          return \ParsedownExtra::instance()->parse($output);
        }
        break;
    }
    return NULL;
  }

}
