<?php

namespace Drupal\field_sample_value\Plugin\Field\SampleValueGenerator;

use Drupal\Core\Database\Database;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\field_sample_value\SampleValueGeneratorBase;
use Drupal\field_sample_value\SampleValueGeneratorInterface;

/**
 * Defines an entity reference generator.
 *
 * @SampleValueGenerator(
 *   id = "entity_reference",
 *   label = @Translation("Entity Reference"),
 *   field_types = {
 *     "entity_reference",
 *   },
 *   weight = 0,
 * )
 */
class EntityReference extends SampleValueGeneratorBase implements SampleValueGeneratorInterface {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
    ] + parent::defaultConfiguration();
  }

  /**
   * {@inheritdoc}
   */
  public function generateSampleValue(FieldItemListInterface $item_list): void {
    $settings = $item_list->getFieldDefinition()->getSettings();
    $entity_type = $settings['target_type'];
    $bundles = $settings['handler_settings']['target_bundles'] ?? NULL;

    $entity_type_manager = \Drupal::entityTypeManager();
    $definition = $entity_type_manager->getDefinition($entity_type);

    $data_table = $definition->getDataTable() ?: $definition->getBaseTable();

    $id_key = $definition->getKey('id');
    $bundle_key = $definition->getKey('bundle');
    $published_key = $definition->getKey('published');

    $select = Database::getConnection()->select($data_table, 'e');
    $select->addField('e', $id_key);

    if ($bundle_key && $bundles) {
      $select->condition("e.$bundle_key", $bundles, 'IN');
    }

    if ($published_key) {
      $select->condition("e.$published_key", 1);
    }

    $select->range(0, 1);
    $select->orderRandom();

    $id = $select->execute()->fetchField();

    if (empty($id)) {
      \Drupal::messenger()->addMessage(\Drupal::translation()->formatPlural(
        count($bundles),
        "Failed to generate @label field because there are no published @type's.",
        "Failed to generate @label field because there are no published items of type: @type's.",
        [
          '@label' => $item_list->getFieldDefinition()->getLabel(),
          '@type' => reset($bundles),
          '@types' => navigation_plus_implode($bundles),
        ]
      ));
      return;
    }

    $item_list->setValue([
      'target_id' => $id,
    ]);
  }

}
