<?php

namespace Drupal\field_style\Utils;

/**
 *
 */
class FieldStyleFonts {

  public $custom_fonts;
  public $fonts;

  /**
   *
   */
  public function __construct() {
    $custom_fonts = [];
    \Drupal::moduleHandler()->invokeAll('field_style_custom_font', [&$custom_fonts]);

    $this->custom_fonts = $custom_fonts;
  }

  /**
   *
   */
  public function build($fonts_used = []) {
    $css = '';

    foreach ($this->custom_fonts as $custom_font) {
      if (isset($fonts_used[$custom_font['family']])) {
        $css .= "@font-face {";
        $css .= "font-family: '" . $custom_font['family'] . "';";
        foreach ($custom_font['variants'] as $variant) {
          if ($variant) {
            $src = [];
            foreach ($custom_font['files'][$variant] as $fKey => $file) {
              if (preg_replace('/^.*\./', '', $file) == 'eot') {
                $src[] = "url('" . $file . "')";
                $src[] = "url('" . $file . '?#iefix' . "') format('embedded-opentype')";
              }
              if (preg_replace('/^.*\./', '', $file) == 'woff') {
                $src[] = "url('" . $file . "') format('woff')";
              }
              if (preg_replace('/^.*\./', '', $file) == 'woff2') {
                $src[] = "url('" . $file . "') format('woff2')";
              }
              if (preg_replace('/^.*\./', '', $file) == 'ttf') {
                $src[] = "url('" . $file . "') format('truetype')";
              }
              if (preg_replace('/^.*\./', '', $file) == 'svg') {
                $src[] = "url('" . $file . "#svgFontName') format('svg')";
              }
            }
            $css .= "src: " . implode(',', $src) . ";";

            $css .= "font-weight: " . str_replace('italic', '', $variant) . ";";
            if (str_contains($variant, 'italic')) {
              $css .= "font-style: italic;";
            }
            else {
              $css .= "font-style: normal;";
            }
          }
        }
        $css .= '}';
      }
    }

    return $css;
  }

}
